;;; -*- Mode:Common-Lisp; Package:EH; Base:8; Fonts:(CPTFONT HL10B HL12BI HL12B CPTFONTB)1; *Patch-File: T -*-

;1;;                     RESTRICTED RIGHTS LEGEND          *
;1;; Use, duplication, or disclosure by the Government is subject to*
;1;; restrictions as set forth in subdivision (b)(3)(ii) of the Rights in*
;1;; Technical Data and Computer Software clause at 52.227-7013.*
;1;;                   TEXAS INSTRUMENTS INCORPORATED.*
;1;;                            P.O. BOX 149149*
;1;;                         AUSTIN, TEXAS 78714-9149*
;1;;                             MS 2151*
;1;; Copyright (C) 1986,1987, 1988, 1989 Texas Instruments Incorporated. All rights reserved.*
;1;----------------------------------------------------------------------*
;1;; This software developed by:*
;1;;*	1James Rice*
;1;; at the Stanford University Knowledge Systems Lab in 1986, 1987.*
;1;;*
;1;; This work was supported in part by:*
;1;;*	1DARPA Grant F30602-85-C-0012*

;1;;----------------------------------------------------------------------*
;1;;  Much of this file is derived from code licensed from Texas Instruments*
;1;;  Inc.  Since we'd like them to adopt these changes, we're claiming*
;1;;  no rights to them, however, the following restrictions apply to the*
;1;;  TI code:*
;1;; Your rights to use and copy Explorer System Software must be obtained*
;1;; directly by license from Texas Instruments Incorporated.  Unauthorized*
;1;; use is prohibited.*

;1****************
;1 TAC 07-25-89 - commented out load-tools - not using Rice's load-tools system *
;1(load-tools '(:window-debugger-enhancements))*

(DEFFLAVOR 4l2-debugger-who-line-mixin* ()
	   (debugger-who-line-mixin)
  (:documentation 
    :combination "3A version of DEBUGGER-WHO-LINE-MIXIN, which supports L2 protocols.*"))

(DEFMETHOD 4(l2-debugger-who-line-mixin :after :init*) (IGNORE)
  (SETQ normal-mouse-doc
	'(:mouse-l-1 "3Inspect selected object.*"
	  :mouse-m-1 "3Set * to object; Echo object in interaction pane.*")))

(DEFMETHOD 4(l2-debugger-who-line-mixin :get-normal-mouse-doc*) ()
  (LET ((item (IF (OR (SEND self :send-if-handles :sensitive-inspect-item)
		      (SEND self :send-if-handles :sensitive-history-item)
		      (SEND self :send-if-handles :current-item))
		  (tv::get-mouse-sensitive-item)
		  nil)))
       (MULTIPLE-VALUE-BIND (perspectives thing)
	   (IF (AND (CONSP item) (THIRD item)
		    (EQUAL :item1 (FIRST item)))
	       (IF (tv::allocated-perspectives (THIRD item))
		   (VALUES (tv::allocated-perspectives (THIRD item)) (THIRD item))
		   (VALUES nil (THIRD item)))
	       (IF (AND item (tv::allocated-perspectives item))
		   (VALUES (tv::allocated-perspectives item) item)
		   (IF (AND (EQUAL
			      (SEND self :send-if-handles :print-function-arg)
			      :list-structure)
			    (LOCATIVEP item)
			    (%p-contents-safe-p item)
			    (tv::allocated-perspectives (FIRST item)))
		       (VALUES (tv::allocated-perspectives (FIRST item)) (FIRST item)))))
           (IGNORE perspectives)
	   (APPEND (SEND (IF (TYPEP thing 'tv::inspection-data)
                             thing
                             (tv::map-into-show-x thing t))
                         :who-line-doc
                         t (NOT thing))
		   '(:allow-override "")
                   normal-mouse-doc))))

(DEFMETHOD 4(l2-debugger-who-line-mixin :who-line-documentation-string*) ()
  "2Who line documentation for the stack, args, locals, history and inspection panes.*"
  (LET*
    ((frame (SEND self :superior))
     (interactor (SEND frame :get-pane 'lisp-window)))
    (OR (SEND frame :who-line-doc-string-overide)
	(IF (SEND frame :doing-typein-p)
	    (SEND interactor :who-line-documentation-string)
	    (MULTIPLE-VALUE-BIND (x y) ;1get mouse position*
		(tv:sheet-calculate-offsets self tv:mouse-sheet)
	      (SETQ x (- system:mouse-x x)
		    y (- system:mouse-y y))
	      (MULTIPLE-VALUE-BIND (item item-type)
		  (SEND self :mouse-sensitive-item x y)
		(COND ((NOT (OR item item-type))
		       '(:mouse-r-1 "3Menu of all window-based debugger commands*"))
		      (t
		       ;1; Change here by JPR.*
                       (OR (CATCH-ERROR (SEND self :get-normal-mouse-doc) nil)
			   "3Error getting doc string.*")))))))))

(DEFFLAVOR 4l2-gray-debugger-text-scroll-pane*
           nil
           (l2-debugger-who-line-mixin gray-debugger-text-scroll-pane)
           (:documentation :combination "3Args window in window-based debugger*"))

(DEFFLAVOR 4l2-gray-debugger-thermometer-text-scroll-pane*
           nil
           (l2-debugger-who-line-mixin gray-debugger-thermometer-text-scroll-pane)
           (:documentation :combination "3Locals window in window-based debugger*"))

(DEFFLAVOR 4l2-stack-scroll-pane*
           ()
           (l2-debugger-who-line-mixin stack-scroll-pane)
           (:documentation :combination "3Stack window in the window-based debugger*"))

;1****************
;1 TAC 08-04-89 - This redefines flavor in WINDOW-DEBUG. It requires that GENERAL-INSPECTOR*
;1                info be compiled first.*
(DEFFLAVOR 4debugger-history-pane*
           nil
           (debugger-who-line-mixin tv::general-inspector-history-window))

(DEFFLAVOR 4l2-debugger-history-pane*
           nil
           (l2-debugger-who-line-mixin debugger-history-pane))

(DEFFLAVOR 4new-debugger-inspect-pane* nil (l2-debugger-who-line-mixin tv::general-inspect-window))

(DEFFLAVOR 4new-debugger-frame* () (debugger-frame))

(DEFMETHOD 4(debugger-frame :before :init*) (IGNORE)
  (UNLESS (AND (boundp-in-instance self 'tv::panes) tv::panes)
  (LET ((io-buf (tv:make-default-io-buffer)))
    (SETQ
      tv::panes
      (LIST 
        `(lisp-window debugger-lisp-listener-pane :label nil :io-buffer ,io-buf)
        `(args-window gray-debugger-text-scroll-pane :label nil :font-map (,fonts:cptfont)
          :io-buffer ,io-buf)
       `(locals-window gray-debugger-thermometer-text-scroll-pane :label nil :font-map (,fonts:cptfont)
          :io-buffer ,io-buf)
        `(stack-window stack-scroll-pane
                       :label nil :io-buffer ,io-buf)
        `(command-menu-window debugger-menu-pane :io-buffer ,io-buf :font-map 
                              (,fonts:cptfont ,fonts:hl10b))
        `(resume-menu-window debugger-menu-pane :io-buffer ,io-buf :font-map 
                             (,fonts:cptfont ,fonts:hl10b))
        `(inspect-window debugger-inspect-pane :io-buffer ,io-buf :font-map (,fonts:cptfont) 
                         :label fonts:hl10b) ;1:SCROLL-BAR-ALWAYS-DISPLAYED T :SCROLL-BAR 2)*
        `(inspect-history-window debugger-history-pane :font-map (,fonts:cptfont)
                                 :io-buffer ,io-buf)))
    (SETQ tv:constraints
          (QUOTE
            ((debugger-configuration (inspect-window args-locals
                                                     stack-window
                                                     menu-history
                                                     lisp-window)
                                     ((menu-history :horizontal
                                                    (5 :lines command-menu-window)
                                                    (command-menu-window resume-menu-window
                                                                         inspect-history-window)
                                                    ((command-menu-window :ask :pane-size))
                                                    ((resume-menu-window :ask :pane-size))
                                                    ((inspect-history-window :even))))
                                     ((args-locals :horizontal
                                                   (6 :lines args-window)
                                                   (args-window locals-window)
                                                   ((args-window :even) (locals-window :even))))
                                     ((lisp-window 7 :lines))
                                     ((inspect-window 0.45s0) (stack-window 0.55s0)))
             (step-configuration
               (stack-window menu-args-locals lisp-window)
               ((menu-args-locals
                  :horizontal
                  (11 :lines command-menu-window)
                  (command-menus args-window locals-window)
                  ((command-menus :vertical
                                  (17 :characters command-menu-window)
                                  (command-menu-window resume-menu-window)
                                  ((command-menu-window :even) (resume-menu-window :even))))
                  ((args-window :even) (locals-window :even))))
               ((lisp-window 7 :lines))
               ((stack-window :even)))))))))

;1; RDA: 1-May-89: Add this*
(DEFVAR 4*debugger-frame-default-edges** nil
  "2If non-NIL, edges used by default when creating NEW-DEBUGGER-FRAMEs.*")

(DEFMETHOD 4(new-debugger-frame :before :init*) (init-plist-pointer)
  ;1; RDA: 1-May-89: Add this and change from IGNORE in arglist*
  (WHEN (AND *debugger-frame-default-edges*
	     (NOT (MEMBER :edges (CONTENTS init-plist-pointer) :test #'EQ)))
    (NCONC (CONTENTS init-plist-pointer) `(:edges ,*debugger-frame-default-edges*)))
  (UNLESS (AND (boundp-in-instance self 'tv::panes) tv::panes)
  (LET ((io-buf (tv:make-default-io-buffer)))
    (SETQ
      tv::panes
      (LIST 
        `(lisp-window debugger-lisp-listener-pane :label nil :io-buffer ,io-buf)
        `(args-window l2-gray-debugger-text-scroll-pane :label nil :font-map (,fonts:cptfont)
          :io-buffer ,io-buf)
        `(locals-window l2-gray-debugger-thermometer-text-scroll-pane :label nil :font-map (,fonts:cptfont)
          :io-buffer ,io-buf)
        `(stack-window l2-stack-scroll-pane
                       :label nil :io-buffer ,io-buf)
        `(command-menu-window debugger-menu-pane :io-buffer ,io-buf :font-map 
                              (,fonts:cptfont ,fonts:hl10b))
        `(resume-menu-window debugger-menu-pane :io-buffer ,io-buf :font-map 
                             (,fonts:cptfont ,fonts:hl10b))
        `(inspect-window new-debugger-inspect-pane :io-buffer ,io-buf :font-map (,fonts:cptfont) 
                         :label fonts:hl10b) ;1:SCROLL-BAR-ALWAYS-DISPLAYED T :SCROLL-BAR 2)*
        `(inspect-history-window l2-debugger-history-pane :font-map (,fonts:cptfont)
                                 :io-buffer ,io-buf)))
    (SETQ tv:constraints
          (QUOTE
            ((debugger-configuration (inspect-window args-locals
                                                     stack-window
                                                     menu-history
                                                     lisp-window)
                                     ((menu-history :horizontal
                                                    (5 :lines command-menu-window)
                                                    (command-menu-window resume-menu-window
                                                                         inspect-history-window)
                                                    ((command-menu-window :ask :pane-size))
                                                    ((resume-menu-window :ask :pane-size))
                                                    ((inspect-history-window :even))))
                                     ((args-locals :horizontal
                                                   (6 :lines args-window)
                                                   (args-window locals-window)
                                                   ((args-window :even) (locals-window :even))))
                                     ((lisp-window 7 :lines))
                                     ((inspect-window 0.45s0) (stack-window 0.55s0)))
             (step-configuration
               (stack-window menu-args-locals lisp-window)
               ((menu-args-locals
                  :horizontal
                  (11 :lines command-menu-window)
                  (command-menus args-window locals-window)
                  ((command-menus :vertical
                                  (17 :characters command-menu-window)
                                  (command-menu-window resume-menu-window)
                                  ((command-menu-window :even) (resume-menu-window :even))))
                  ((args-window :even) (locals-window :even))))
               ((lisp-window 7 :lines))
               ((stack-window :even)))))))))

(DEFMETHOD 4(new-debugger-frame :around :handle-unknown-input*) (cont mt ignore)
  (LET (operation value window list (sg *error-sg*))
    (WHEN (LISTP ucl:kbd-input)
      (SETQ list ucl:kbd-input
            operation (FIRST list)
            value (SECOND list)
            window (THIRD list))
      (WHEN (NOT (MEMBER operation '(:line-area :mouse-button) :test (FUNCTION eq)))
        (IF (EQL (INT-CHAR (FOURTH list)) #\Mouse-l)		;1.*
            (SETQ operation :inspect)
            (IF (SEND *window-debugger* :inspect-window-p window)
                (SETQ operation :value
                      value (tv::inspect-real-value list))))))
    (IF (NOT (MEMBER operation '(:line-area :inspect :value :function stack-frame special arg 
                                            local) :test (FUNCTION eq)))
        (FUNCALL-WITH-MAPPING-TABLE cont mt :handle-unknown-input)
        (CASE operation
	  (:line-area
	   (UNLESS (SEND *window-debugger* :inspect-window-p window)	;1see above comments!*
	     (SETQ *current-frame* value)
	     (SEND *window-debugger* :setup-frame sg *current-frame*)))
	  (:inspect
	   (IF (SEND *window-debugger* :inspect-window-p window)
	       (CASE (FOURTH ucl::kbd-input)
		 (#\Mouse-l-2 (SEND self :inspect-info-left-2-click))
		 (otherwise (LET ((ivalue (tv::inspect-real-value list)))
			      (IF (AND (NOT tv::*debugging?*)
				       (TYPEP ivalue 'tv::inspection-data)
				       (operation-handled-p ivalue :handle-mouse-click)
				       (CATCH-ERROR 
					 (PROGN 
					   (SEND ivalue :handle-mouse-click ucl:kbd-input *window-debugger*) 
					   t) 
					 nil))
				  nil
				  (SEND *window-debugger* :inspect-object ivalue)))))
	       (SEND *window-debugger* :inspect-object
		     (CASE (FIRST list)
		       (:menu  (EQ (SEND (FOURTH list) :execute (SECOND list)) t))
		       (stack-frame  (list-stack-frame-function-and-args *error-sg*
									 (SECOND list)))
		       (:line-area
			(list-stack-frame-function-and-args *error-sg*
							    (SECOND list)))
		       ((SPECIAL arg local)  (FIRST (SECOND list)))
		       ((:value :function)  (SECOND list))))))
	  ((LIST :value :function stack-frame special arg local)
	   (SETQ +++ ++
		 ++  +)
	   (COND
	     ((MEMBER operation '(SPECIAL arg local) :test (FUNCTION eq))
	      (COND
		((MEMBER operation '(arg local) :test (FUNCTION eq))
		 (PRIN1 (FIRST value))
		 (LET ((idx (SECOND value)))
		   (IF (NOT (NUMBERP idx))
		       (AND (EQUALP idx "3Rest arg*")
			    (SETQ value (sg-rest-arg-value sg *current-frame*)))
		       (PROGN
			 (LET ((rp (sg-regular-pdl sg)))
			   (SETQ +
				 (ALOC rp
				       (+ idx
					  (IF (EQ operation 'arg) 
					      (sys:rp-argument-offset sg rp *current-frame*)
					      (sys:rp-local-offset sg rp *current-frame*))))))
								;1; old way of looking for args and locals:*
								;1; (ALOC RP*
								;1;      (+ *CURRENT-FRAME* IDX*
								;1;*	1  (IF (EQ OPERATION 'ARG) 1*
								;1;                 (RP-LOCAL-BLOCK-ORIGIN*
								;1;*	1      RP CURRENT-FRAME))))))*
			 (SETQ value (CAR +))))))
		(t (SETQ + (PRIN1 value))
		   (SETQ value (SYMBOL-VALUE value))))
	      (TERPRI))
	     ((EQ operation 'stack-frame)
	      (SETQ value (stack-frame-into-list value sg)))
	     ((EQL (FOURTH ucl::kbd-input) #\Mouse-l-2)
	      (SEND self :inspect-info-left-2-click))
	     ((LET ((ivalue (tv::inspect-real-value list)))
		(AND (TYPEP ivalue 'tv::inspection-data)
		     (operation-handled-p ivalue :handle-mouse-click)
		     (CATCH-ERROR 
		       (PROGN 
			 (SEND ivalue :handle-mouse-click ucl:kbd-input *window-debugger*)
			 t) 
		       nil)))))
	   (SEND *terminal-io* :fresh-line)
	   (SETQ *** **
		 **  *
		 *   (IF (TYPEP value 'tv::inspection-data)
			 (SEND value :send-if-handles :middle-button-result)
			 value))
	   (IF (NOT (EQUAL #\mouse-l-2 (FOURTH ucl:kbd-input))) (PRINT *))
	   (SEND self :handle-prompt))))))

(PUTPROP :function 'SECOND 'tv::value-function)

(DEFMETHOD 4(new-debugger-frame :inspect-thing*)
           (type thing &optional (aux-data nil aux-supplied?))
  (LET ((inspected-thing
	 (tv::inspect-real-value
	  `(:value
	    ,(IF aux-supplied?
	       (tv::allocate-data type thing aux-data)
	       (tv::allocate-data type thing))
	    ,inspect-history-window))))
    (SEND *window-debugger* :inspect-object inspected-thing)))

(DEFMETHOD 4(new-debugger-frame :inspect-info-left-2-click*)
	   (&optional something)
  (LET ((thing (IF something
		   something
		   (tv::inspect-real-value ucl:kbd-input))))
       (MULTIPLE-VALUE-BIND (real-thing inspect-p)
	   (tv::map-into-show-x thing)
	 (IF inspect-p
	     (SEND *window-debugger* :inspect-object real-thing)
	     nil))))

(DEFMETHOD 4(new-debugger-frame :inspection-data-active?*) ()
  t)

(install-window-debugger-commands)

;1(compile-flavor-methods l2-debugger-who-line-mixin*
;			1l2-gray-debugger-text-scroll-pane*
;			1l2-gray-debugger-thermometer-text-scroll-pane*
;			1l2-stack-scroll-pane*
;			1l2-debugger-history-pane*
;			1new-debugger-inspect-pane*
;			1new-debugger-frame
*;1)